/*
 * Decompiled with CFR 0.152.
 */
package net.firemuffin303.thaidelight.common.registry;

import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.firemuffin303.thaidelight.common.entity.Dragonfly;
import net.firemuffin303.thaidelight.common.entity.FlowerCrabEntity;
import net.firemuffin303.thaidelight.mixin.SpawnPlacementMixin;
import net.firemuffin303.thaidelight.utils.ModPlatform;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.level.levelgen.Heightmap;

public class ModEntityTypes {
    public static final ArrayList<EntityType<?>> ENTITY_TYPES = new ArrayList();
    public static final EntityType<FlowerCrabEntity> FLOWER_CRAB = EntityType.Builder.m_20704_(FlowerCrabEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.8f, 0.5f).m_20712_("muffins_thaidelight");
    public static final EntityType<Dragonfly> DRAGONFLY = EntityType.Builder.m_20704_(Dragonfly::new, (MobCategory)MobCategory.AMBIENT).m_20699_(0.8f, 0.6f).m_20712_("muffins_thaidelight");

    public static void init() {
        ModEntityTypes.register("flower_crab", FLOWER_CRAB);
        ModEntityTypes.register("dragonfly", DRAGONFLY);
    }

    private static <T extends Entity> void register(String id, EntityType<T> entityType) {
        ModPlatform.registerEntityType(id, entityType);
        ENTITY_TYPES.add(entityType);
    }

    public static void registerAttributes(BiConsumer<Supplier<? extends EntityType<? extends LivingEntity>>, Supplier<AttributeSupplier.Builder>> attributes) {
        attributes.accept(() -> FLOWER_CRAB, FlowerCrabEntity::createAttributes);
        attributes.accept(() -> DRAGONFLY, Dragonfly::createAttributes);
    }

    public static void postInit() {
        SpawnPlacementMixin.invokeRegister(FLOWER_CRAB, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, FlowerCrabEntity::checkSpawnRules);
        SpawnPlacementMixin.invokeRegister(DRAGONFLY, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
    }
}

